<?php

class Whatsapp_Model extends MVC_Model
{
	public function checkWid($uid, $wid)
	{
		$this->db->query("SELECT id FROM wa_accounts WHERE uid = ? AND wid LIKE ?", [
			$uid,
			"{$wid}%"
		]);

		return $this->db->num_rows();
	}

	public function checkAccount($uid, $unique)
	{
		$this->db->query("SELECT id FROM wa_accounts WHERE uid = ? AND `unique` = ?", [
			$uid,
			$unique
		]);

		return $this->db->num_rows();
	}

	public function getUserEmail($id)
    {
        $fetch = $this->db->query_one("SELECT email FROM users WHERE id = ?", [
            $id
        ]);

        return $fetch ? $fetch["email"] : false;
    }

    public function getUserLanguage($id)
    {
        $fetch = $this->db->query_one("SELECT language FROM users WHERE id = ?", [
            $id
        ]);

        return $fetch ? $fetch["language"] : 1;
    }

	public function getUserTimezone($id)
    {
        $fetch = $this->db->query_one("SELECT timezone FROM users WHERE id = ?", [
            $id
        ]);

        return $fetch ? $fetch["timezone"] : "UTC";
    }

	public function getPendingMessages($uid, $wid, $recover = 2)
	{
		$query = <<<SQL
SELECT id, uid, wid, phone, message
FROM wa_sent
WHERE uid = ? AND wid LIKE ? AND status < ?
SQL;

        $this->db->query($query, [
            $uid,
            "{$wid}%",
            $recover < 2 ? 3 : 2
        ]);

        if ($this->db->num_rows() > 0):
            while ($row = $this->db->next())
                $rows[] = $row;

            return $rows;
        else:
            return [];
        endif;
	}
}