<?php

class Whatsapp_Controller extends MVC_Controller
{
	public function index()
	{
		$this->header->allow();

		response(404);
	}

	public function messages()
	{
		$this->header->allow();

		$request = $this->sanitize->array($_GET);

		if(!isset($request["system_token"], $request["uid"], $request["wid"], $request["hash"], $request["unique"]))
			response(500);

		if($request["system_token"] != system_token)
			response(500);

		$this->cache->container("system.settings");

        if($this->cache->empty()):
            $this->cache->setArray($this->system->getSettings());
        endif;

        set_system($this->cache->getAll());

		if($this->whatsapp->checkAccount($request["uid"], $request["unique"]) > 0):
			$phone = explode(":", $request["wid"]);
			$messages = $this->whatsapp->getPendingMessages($request["uid"], $phone[0]);

			$this->echo->_cache = $this->cache;
			$this->echo->_guzzle = $this->guzzle;

			try {
				$echoToken = $this->echo->token();
			} catch(Exception $e){
				response(500);
			}

			foreach($messages as $row):
	        	$this->system->update($row["id"], false, "wa_sent", [
        			"status" => 2
        		]);

				if($echoToken):
					$this->echo->notify($request["hash"], [
						"type" => "table"
					]);
				endif;
			endforeach;

			response(200, false, $messages);
		else:
			response(500);
		endif;
	}

	public function link()
	{
		$this->header->allow();

		$type = $this->url->segment(4);
		$request = $this->sanitize->array($_GET);

		if($type == "success"):
			if(!isset($request["system_token"], $request["uid"], $request["wid"], $request["unique"]))
				response(500);

			if($request["system_token"] != system_token)
				response(500);

			date_default_timezone_set($this->whatsapp->getUserTimezone($request["uid"]));

			$filtered = [
				"uid" => $request["uid"],
				"wid" => $request["wid"],
				"unique" => $request["unique"],
				"create_date" => date("Y-m-d H:i:s", time())
			];

			$phone = explode(":", $request["wid"]);

			if($this->whatsapp->checkWid($request["uid"], $phone[0]) < 1):
				if($this->system->create("wa_accounts", $filtered)):
					response(200);
				else:
					response(500);
				endif;
			else:
				response(302);
			endif;
		else:
			if(!isset($request["system_token"], $request["uid"], $request["unique"]))
				response(500);

			if($request["system_token"] != system_token)
				response(500);

			if($this->system->delete($request["uid"], false, "wa_accounts", [
				"uid" => $request["uid"],
				"unique" => $request["unique"]
			])):
				response(200);
			else:
				response(500);
			endif;
		endif;
	}

	public function sent()
	{
		$this->header->allow();

		$request = $this->sanitize->array($_GET);

		if(!isset($request["system_token"], $request["id"], $request["uid"], $request["hash"], $request["phone"], $request["message"], $request["status"]))
			response(500);

		if($request["system_token"] != system_token)
			response(500);

		$this->cache->container("system.settings");

        if($this->cache->empty()):
            $this->cache->setArray($this->system->getSettings());
        endif;

        set_system($this->cache->getAll());

        set_language($this->whatsapp->getUserLanguage($request["uid"]));

        $subscription = set_subscription(
            $this->system->checkSubscription($request["uid"]), 
            $this->system->getSubscription(false, $request["uid"]), 
            $this->system->getSubscription(false, false, true)
        );

		if(empty($subscription))
			response(403);

		date_default_timezone_set($this->whatsapp->getUserTimezone($request["uid"]));

		$filtered = [
			"status" => $request["status"],
			"create_date" => date("Y-m-d H:i:s", time())
		];

		if($this->system->update($request["id"], $request["uid"], "wa_sent", $filtered)):
			$this->echo->_cache = $this->cache;
			$this->echo->_guzzle = $this->guzzle;

			try {
				$echoToken = $this->echo->token();
			} catch(Exception $e){
				response(403);
			}

			if($request["status"] == 3):
				if($echoToken):
					$this->echo->notify($request["hash"], [
						"type" => "message",
						"status" => 1,
						"content" => ___(__("lang_whatsapp_sent_sentsuccess"), ["<strong><a href=\"#\" class=\"text-warning\" zender-toggle=\"zender.view/wa.sent-{$request["id"]}\">#{$request["id"]}</a></strong>"])
					]);
				endif;
			else:
				if($echoToken):
					$this->echo->notify($request["hash"], [
						"type" => "message",
						"status" => 2,
						"content" => ___(__("lang_whatsapp_sent_sentfailed"), ["<strong><a href=\"#\" class=\"text-warning\" zender-toggle=\"zender.view/wa.sent-{$request["id"]}\">#{$request["id"]}</a></strong>"])
					]);
				endif;
			endif;

			$this->system->increment($request["uid"], "wa_sent");

			$this->process->_sanitize = $this->sanitize;
			$this->process->_guzzle = $this->guzzle;
			$this->process->_lex = $this->lex;

			/**
			 * Process Action Hooks
			 */

			$hooks = $this->process->actionHooks($request["uid"], 2, 1, $request["phone"], $request["message"], $this->device->getActions($request["uid"], 2));

			if(!empty($hooks)):
				foreach($hooks as $hook):
					$this->system->create("events", [
						"uid" => $request["uid"],
						"type" => 2,
						"create_date" => date("Y-m-d H:i:s", time())
					]);
				endforeach;
			endif;

			response(200);
		else:
			response(500);
		endif;
	}

	public function received()
	{
		$this->header->allow();

		$request = $this->sanitize->array($_GET);

		if(!isset($request["system_token"], $request["uid"], $request["hash"], $request["wid"], $request["phone"], $request["message"], $request["timestamp"]))
			response(500);

		if($request["system_token"] != system_token)
			response(500);

		$this->cache->container("system.settings");

        if($this->cache->empty()):
            $this->cache->setArray($this->system->getSettings());
        endif;

        set_system($this->cache->getAll());

        set_language($this->whatsapp->getUserLanguage($request["uid"]));

        $subscription = set_subscription(
            $this->system->checkSubscription($request["uid"]), 
            $this->system->getSubscription(false, $request["uid"]), 
            $this->system->getSubscription(false, false, true)
        );

		if(empty($subscription))
			response(403);

		date_default_timezone_set($this->whatsapp->getUserTimezone($request["uid"]));

		if(!limitation($subscription["receive_limit"], $this->system->countQuota($request["uid"], "wa_received"))):
			$filtered = [
				"uid" => $request["uid"],
				"wid" => $request["wid"],
				"phone" => "+{$request["phone"]}",
				"message" => base64_decode($request["message"]),
				"receive_date" => date("Y-m-d H:i:s", $request["timestamp"])
			];

			$received = $this->system->create("wa_received", $filtered);

			if($received):
				$this->echo->_cache = $this->cache;
				$this->echo->_guzzle = $this->guzzle;

				try {
					$echoToken = $this->echo->token();
				} catch(Exception $e){
					response(403);
				}

				if($echoToken):
					$this->echo->notify($request["hash"], [
						"type" => "message",
						"status" => 1,
						"content" => ___(__("lang_whatsapp_received_chat"), ["<strong><a href=\"#\" class=\"text-warning\" zender-toggle=\"zender.view/wa.received-{$received}\">#{$received}</a></strong>"])
					]);
				endif;

				$this->system->increment($request["uid"], "wa_received");

				$this->process->_sanitize = $this->sanitize;
				$this->process->_guzzle = $this->guzzle;
				$this->process->_lex = $this->lex;

				/**
				 * Process Webhooks
				 */

				$wid = explode(":", $filtered["wid"]);

				$webhooks = $this->process->webhooks($filtered["uid"], "whatsapp", [
					"id" => (int) $received,
					"wid" => "+{$wid[0]}",
					"phone" => $filtered["phone"],
					"message" => $filtered["message"],
					"timestamp" => strtotime($filtered["receive_date"])
				], $this->device->getWebhooks($filtered["uid"], "whatsapp"));

				if(!empty($webhooks)):
					foreach($webhooks as $webhook):
						$this->system->create("events", [
							"uid" => $filtered["uid"],
							"type" => 1,
							"create_date" => date("Y-m-d H:i:s", time())
						]);
					endforeach;
				endif;

				/**
				 * Process Action Hooks
				 */

				$hooks = $this->process->actionHooks($filtered["uid"], 2, 2, $filtered["phone"], $filtered["message"], $this->device->getActions($filtered["uid"], 2));

				if(!empty($hooks)):
					foreach($hooks as $hook):
						$this->system->create("events", [
							"uid" => $filtered["uid"],
							"type" => 2,
							"create_date" => date("Y-m-d H:i:s", time())
						]);
					endforeach;
				endif;

				/**
				 * Process Action Autoreplies
				 */

				$autoreplies = $this->process->actionAutoreplies($filtered["uid"], 2, $filtered["phone"], $filtered["message"], $this->device->getActions($filtered["uid"], 2));

				if(!empty($autoreplies)):
					$account = $this->system->getWaAccount($filtered["uid"], $filtered["wid"], "wid");

					foreach($autoreplies as $autoreply):
						$this->system->create("wa_sent", [
				        	"uid" => $filtered["uid"],
							"wid" => $account["wid"],
							"phone" => $filtered["phone"],
							"message" => $autoreply["message"],
							"status" => 1,
							"api" => 2,
							"create_date" => date("Y-m-d H:i:s", time())
				        ]);

					    $this->system->create("events", [
							"uid" => $filtered["uid"],
							"type" => 2,
							"create_date" => date("Y-m-d H:i:s", time())
						]);

					    if($echoToken):
							$this->wa->send($echoToken, $account["unique"], $filtered["uid"], $request["hash"]);
						endif;
					endforeach;
				endif;

				response(200);
			else:
				response(500);
			endif;
		endif;
	}
}